/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ͨUSB CDC(Communication Device Class)ЭʶΪ豸ISP(V6.90Ժ汾);

ISPԽӿϵӦļֵMCU;

MCUյִֵжӦĹ;

ʾָλUSBģʽķ
1. ͨÿ1ִһΡKeyResetScanʵֳP3.2ڰMCUλUSBģʽ
   (ϣλUSBģʽĻڸλｫ IAP_CONTR bit60ѡλû)
2. ͨءstc_usb_cdc_8h_data.LIB⺯ʵʹISPָMCUλUSBģʽԶء
   (ע⣺ʹCDCӿڴMCUλԶعܣҪѡ˿ã´ǿʹáUSB Writer (HID)ISP)

ʱ, ѡʱ 24MHZ (û޸Ƶ)

******************************************/

#define PRINTF_SEGLED        //printfضISPе7

#include "../comm/AI8051U.h"  //ͷļ󣬲Ҫٰ"reg51.h"ͷļ
#include "usb.h"     //USBԼλͷļ
#include "vk.h"
#include "pic.h"

#define MAIN_Fosc       24000000L   //ʱ

BYTE xdata cod[8];

char *USER_DEVICEDESC = NULL;
char *USER_PRODUCTDESC = NULL;
char *USER_STCISPCMD = "@STCISP#";                      //ԶλISPûӿ

//P3.2ڰλ
bit Key_Flag;
u16 Key_cnt;

void sys_init();
void delay_ms(u8 ms);
void KeyResetScan(void);

void main()
{
    sys_init();
    usb_init();
    EA = 1;
    
    while (1)
    {
        delay_ms(1);
        KeyResetScan();   //P3.2ڰλUSBģʽҪ˹ܿɾд

        if(DeviceState != DEVSTATE_CONFIGURED)  //жUSB豸Ƿ
            continue;

        if (bUsbOutReady)
        {
            if ((UsbOutBuffer[0] == 'K') &&
                (UsbOutBuffer[1] == 'E') &&
                (UsbOutBuffer[2] == 'Y') &&
                (UsbOutBuffer[3] == 'P'))
            {
                switch (UsbOutBuffer[5])
                {
                case VK_DIGIT_1:
                    printf("%08lx", 0x1234abcdL);      //ʾַ
                    break;
                case VK_DIGIT_2:
                    SEG7_ShowLong(0x98765432, 16);     //ʾ4ֽڳ
                    break;
                case VK_DIGIT_3:
                    SEG7_ShowFloat(3.1415);            //ʾIEEE754ʽȸ
                    break;
                case VK_DIGIT_4:
                    cod[0] = 0x3f;
                    cod[1] = 0x06;
                    cod[2] = 0x5b;
                    cod[3] = 0x4f;
                    cod[4] = 0x66;
                    cod[5] = 0x6d;
                    cod[6] = 0x7d;
                    cod[7] = 0x27;
                    SEG7_ShowCode(cod);                //ֱʾĶ
                    break;
                case VK_DIGIT_5:
                    cod[0] = 0x01;    //λP0Ч
                    cod[1] = 0xaa;    //P0״̬
                    LED40_SendData(cod, 2);            //DIP40ĸܽLED״̬
                    break;
                case VK_DIGIT_6:
                    cod[0] = 0x0f;    //λP0~P3Ч
                    cod[1] = 0x12;    //P0״̬
                    cod[2] = 0x34;    //P1״̬
                    cod[3] = 0x56;    //P2״̬
                    cod[4] = 0x78;    //P3״̬
                    LED40_SendData(cod, 5);            //DIP40ĸܽLED״̬
                    break;
                case VK_DIGIT_7:
                    cod[0] = 0x01;    //λP0Ч
                    cod[1] = 0xaa;    //P0״̬
                    LED64_SendData(cod, 2);            //DIP64ĸܽLED״̬
                    break;
                case VK_DIGIT_8:
                    cod[0] = 0x0f;    //λP0~P3Ч
                    cod[1] = 0x12;    //P0״̬
                    cod[2] = 0x34;    //P1״̬
                    cod[3] = 0x56;    //P2״̬
                    cod[4] = 0x78;    //P3״̬
                    LED64_SendData(cod, 5);            //DIP64ĸܽLED״̬
                    break;
                case VK_ALPHA_A:
                    LCD12864_DisplayOff();             //رLCD12864ʾ
                    break;
                case VK_ALPHA_B:
                    LCD12864_DisplayOn();              //LCD12864ʾ
                    break;
                case VK_ALPHA_C:
                    LCD12864_CursorOff();              //LCD12864Ĺ
                    break;
                case VK_ALPHA_D:
                    LCD12864_CursorOn();               //ʾLCD12864Ĺ
                    break;
                case VK_ALPHA_E:
                    LCD12864_CursorMoveLeft();         //ƶһλ16أ
                    break;
                case VK_ALPHA_F:
                    LCD12864_CursorMoveRight();        //ƶһλ16أ
                    break;
                case VK_ALPHA_G:
                    LCD12864_CursorReturnHome();       //صϽǳʼλ
                    break;
                case VK_ALPHA_H:
                    LCD12864_ScrollLeft();             //Ļһλ16أ
                    break;
                case VK_ALPHA_I:
                    LCD12864_ScrollRight();            //Ļҹһλ16أ
                    break;
                case VK_ALPHA_J:
                    LCD12864_ScrollUp(16);             //ĻϹһλ16أ
                    break;
                case VK_ALPHA_K:
                    LCD12864_AutoWrapOff();            //رԶй
                    break;
                case VK_ALPHA_L:
                    LCD12864_AutoWrapOn();             //Զй
                    break;
                case VK_ALPHA_M:
                    LCD12864_ReverseLine(1);           //ʾָ
                    break;
                case VK_ALPHA_N:
                    LCD12864_DisplayClear();           //ʾ
                    break;
                case VK_ALPHA_O:
                    LCD12864_ShowString(0, 0, "ڹо˹޹˾");  //LCD12864ʾASCIIͼַ
                    break;
                case VK_ALPHA_P:
                    LCD12864_ShowPicture(0, 0, 8, 64, (BYTE *)&LCD12864_IMG);  //LCD12864ĻʾͼƬ
                    break;
                case VK_ALPHA_Q:
                    OLED12864_DisplayOff();            //رOLED12864ʾ
                    break;
                case VK_ALPHA_R:
                    OLED12864_DisplayOn();             //OLED12864ʾ
                    break;
                case VK_ALPHA_S:
                    OLED12864_DisplayContent();        //ʾĻ
                    break;
                case VK_ALPHA_T:
                    OLED12864_DisplayEntire();         //ȫڲԣ
                    break;
                case VK_ALPHA_U:
                    OLED12864_HorizontalMirror();      //ˮƽʾ
                    break;
                case VK_ALPHA_V:
                    OLED12864_VerticalMirror();        //ֱʾ
                    break;
                case VK_ALPHA_W:
                    OLED12864_DisplayReverse();        //ʾ
                    break;
                case VK_ALPHA_X:
                    OLED12864_SetContrast(0x10);       //ֵΧ0255
                    break;
                case VK_ALPHA_Y:
                    OLED12864_SetContrast(0x80);       //ֵΧ0255
                    break;
                case VK_ALPHA_Z:
                    OLED12864_SetContrast(0xf0);       //ֵΧ0255
                    break;
                case VK_UP:
                    //1ʼҳΧ07
                    //2ĽҳΧ07
                    //3ֵڵλΪ룩
                    OLED12864_ScrollUp(1, 6, 200);     //ú÷ͨOLED12864_ScrollStartָʼִ
                    break;
                case VK_DOWN:
                    OLED12864_ScrollStart();           //ʼִй
                    break;
                case VK_LEFT:
                    //1ʼҳΧ07
                    //2ĽҳΧ07
                    //3ֵڵλΪ룩
                    OLED12864_ScrollLeft(0, 2, 200);   //ú÷ͨOLED12864_ScrollStartָʼִ
                    break;
                case VK_RIGHT:
                    //1ʼҳΧ07
                    //2ĽҳΧ07
                    //3ֵڵλΪ룩
                    OLED12864_ScrollRight(0, 2, 200);  //ú÷ͨOLED12864_ScrollStartָʼִ
                    break;
                case VK_HOME:
                    OLED12864_SetAddressMode(0);       //Ѱַģʽ0ˮƽѰַ 1ֱѰַ 2ҳѰַ
                    break;
                case VK_END:
                    OLED12864_SetAddressMode(1);       //Ѱַģʽ0ˮƽѰַ 1ֱѰַ 2ҳѰַ
                    break;
                case VK_PRIOR:    //PageUp
                    OLED12864_ScrollStop();            //ִֹͣй
                    break;
                case VK_NEXT:     //PageDown
                    OLED12864_ShowPicture(0, 0, 128, 8, (BYTE *)&OLED12864_IMG);  //OLED12864ĻʾͼƬ
                    break;
                }
            }
            else
            {
                USB_SendData(UsbOutBuffer,OutNumber);    //ݻ
            }
            usb_OUT_done();
        }
    }
}

void sys_init()
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
}

//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2021-3-9
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
     u16 i;
     do{
          i = MAIN_Fosc / 6000;
          while(--i);   //6T per loop
     }while(--ms);
}

//========================================================================
// : void KeyResetScan(void)
// : P3.2ڰ1봥λUSBģʽ
// : none.
// : none.
// 汾: VER1.0
// : 2022-6-11
// ע: 
//========================================================================
void KeyResetScan(void)
{
    if(!P32)
    {
        if(!Key_Flag)
        {
            Key_cnt++;
            if(Key_cnt >= 1000)		//1000msЧ
            {
                Key_Flag = 1;		//ð״ֹ̬ظ

                USBCON = 0x00;      //USB
                USBCLK = 0x00;
                IRC48MCR = 0x00;
                
                delay_ms(10);
                IAP_CONTR = 0x60;   //λISPʼִ
                while (1);
            }
        }
    }
    else
    {
        Key_cnt = 0;
        Key_Flag = 0;
    }
}
